# MaskHosting - Professional Offshore Hosting Website

A stunning, professional website for MaskHosting - an offshore DMCA ignored hosting provider. Built with PHP, Tailwind CSS, and featuring a unique cyberpunk-inspired design aesthetic.

## 🎨 Design Features

- **Unique Aesthetic**: Cyberpunk-inspired design with neon green (#00ff88) accent colors
- **Animated Background**: Dynamic grid animation with floating gradient orbs
- **Responsive Design**: Fully mobile-responsive using Tailwind CSS
- **Professional Typography**: Orbitron for headings, Outfit for body text
- **Smooth Animations**: CSS animations throughout for enhanced user experience
- **Modern UI Components**: Cards, buttons, forms with glassmorphism effects

## 📁 File Structure

### Core Files
- `config.php` - Site-wide configuration (URLs, contact info, page titles)
- `header.php` - Global header with navigation
- `footer.php` - Global footer with links and trust badges

### Page Files
- `home.php` - Homepage with hero section, features, pricing preview, testimonials
- `about.php` - Company information, mission, timeline, values
- `shared-hosting.php` - Offshore shared hosting details and features
- `vps-hosting.php` - VPS and cloud hosting solutions
- `domains.php` - Domain registration with search and pricing
- `pricing.php` - Complete pricing tables with monthly/annual toggle
- `contact.php` - Contact form and support information
- `faq.php` - Comprehensive FAQ with categorized questions

## 🚀 Key Features

### 1. **Domain Search Functionality**
- Interactive domain search on home page and domains page
- Redirects to client area (my.maskhosting.com) for registration
- Popular extension suggestions
- Real-time search validation

### 2. **Professional Navigation**
- Fixed header with scroll effects
- Mobile-responsive hamburger menu
- Active page indicators
- Smooth transitions

### 3. **Trust & Conversion Elements**
- Customer testimonials with 5-star ratings
- Trust badges (99.9% Uptime, SSL, 24/7 Support, Privacy)
- Social proof statistics
- Clear call-to-action buttons throughout

### 4. **Pricing Tables**
- Three shared hosting tiers (Starter, Professional, Business)
- Four VPS tiers (Basic, Standard, Advanced, Enterprise)
- Monthly/Annual pricing toggle with 20% savings
- Domain pricing table with all extensions
- Management level options for VPS

### 5. **Contact Forms**
- Professional contact form with validation
- Multiple contact methods displayed
- Support ticket integration
- Live chat placeholder

### 6. **FAQ System**
- Category-based filtering (General, Hosting, Domains, Billing, Technical)
- Accordion-style answers
- Search-friendly content
- Comprehensive coverage of common questions

## 🔧 Configuration

### Update Site Settings
Edit `config.php` to customize:

```php
// Site URLs
define('SITE_URL', 'https://maskhosting.com');
define('CLIENT_AREA_URL', 'https://my.maskhosting.com');

// Contact Information
define('CONTACT_EMAIL', 'support@maskhosting.com');
define('SALES_EMAIL', 'sales@maskhosting.com');
define('CONTACT_PHONE', '+1 (555) 123-4567');

// Social Media
define('TWITTER_URL', 'https://twitter.com/maskhosting');
define('FACEBOOK_URL', 'https://facebook.com/maskhosting');
define('TELEGRAM_URL', 'https://t.me/maskhosting');
```

## 💻 Technology Stack

- **Frontend Framework**: Tailwind CSS (CDN)
- **Backend**: PHP
- **Fonts**: Google Fonts (Orbitron, Outfit, Bebas Neue)
- **Icons**: Font Awesome 6.5.1
- **JavaScript**: Vanilla JS for interactivity

## 🎯 SEO Optimized

- Meta titles and descriptions for each page
- Semantic HTML structure
- Schema markup ready
- Fast loading with CDN resources
- Mobile-friendly design

## 📱 Responsive Breakpoints

- Mobile: < 768px
- Tablet: 768px - 1024px
- Desktop: > 1024px
- Large Desktop: > 1280px

## 🔐 Security Features Highlighted

- DMCA Ignored hosting
- Offshore data centers
- No-logs policy
- WHOIS privacy protection
- DDoS protection
- SSL certificates included
- Enterprise-grade security

## 🎨 Color Scheme

```css
Primary: #00ff88 (Neon Green)
Primary Dark: #00cc6a
Secondary: #0a0e27 (Dark Blue)
Accent: #ff00ff (Magenta)
Dark: #050810
Dark Light: #0f1629
Text Primary: #ffffff
Text Secondary: #a0aec0
```

## 📝 Content Highlights

### Services Offered
1. **Offshore Shared Hosting** - Starting at $4.99/mo
2. **VPS Hosting** - Starting at $19.99/mo
3. **Cloud Hosting** - Starting at $29.99/mo
4. **Domain Registration** - From $9.99/year

### Key Selling Points
- ✅ DMCA Ignored Policies
- ✅ Complete Privacy Protection
- ✅ 99.9% Uptime Guarantee
- ✅ 24/7 Expert Support
- ✅ Unlimited Bandwidth
- ✅ Free SSL Certificates
- ✅ cPanel Control Panel
- ✅ Daily Backups
- ✅ 30-Day Money-Back Guarantee

## 🔗 Integration Points

### Client Area Integration
All "Get Started", "Order Now", and domain search buttons link to:
```
https://my.maskhosting.com/cart.php?a=add&pid=X
https://my.maskhosting.com/cart.php?a=add&domain=register
```

### Form Submissions
Contact form currently shows success message (client-side). To integrate:
1. Create a PHP handler for form submission
2. Connect to email service or CRM
3. Add reCAPTCHA for spam protection

## 🚀 Deployment Instructions

1. **Upload all files** to your web server
2. **Update config.php** with your actual details
3. **Test all links** to ensure client area URLs are correct
4. **Configure email** in contact form handler
5. **Add SSL certificate** to your domain
6. **Test responsive design** on various devices

## 📊 Performance Optimization

- Use CDN for Tailwind CSS and Font Awesome
- Optimize images (none currently, but recommended for production)
- Enable gzip compression on server
- Implement browser caching
- Consider lazy loading for below-fold content

## 🎭 Customization Tips

### Change Color Scheme
Update CSS variables in `header.php`:
```css
:root {
    --primary: #00ff88;      /* Your primary color */
    --primary-dark: #00cc6a; /* Darker shade */
    --accent: #ff00ff;       /* Accent color */
}
```

### Add New Pages
1. Create new `pagename.php`
2. Add to navigation in `header.php`
3. Add page title/description in `config.php`
4. Include header and footer

### Modify Pricing
Edit pricing in `pricing.php`:
- Update plan features
- Change prices
- Modify billing cycles
- Add/remove tiers

## 🐛 Browser Support

- Chrome/Edge: ✅ Full support
- Firefox: ✅ Full support
- Safari: ✅ Full support
- Mobile browsers: ✅ Full support

## 📞 Support

This website is designed to showcase MaskHosting's services professionally. For technical support with modifications or customization, refer to standard PHP and Tailwind CSS documentation.

## ⚖️ License

This website template is created specifically for MaskHosting. Customize as needed for your hosting business.

---

**Built with attention to detail and modern web design principles.**

Created: January 2026
