<?php
// MaskHosting Configuration File

// Site Information
define('SITE_NAME', 'MaskHosting');
define('SITE_URL', 'https://maskhosting.com');
define('CLIENT_AREA_URL', 'https://my.maskhosting.com');

// Contact Information
define('CONTACT_EMAIL', 'support@maskhosting.com');
define('SALES_EMAIL', 'sales@maskhosting.com');
define('CONTACT_PHONE', '+1 (555) 123-4567');

// Social Media Links
define('TWITTER_URL', '#');
define('FACEBOOK_URL', '#');
define('TELEGRAM_URL', '#');

// Page Titles
$page_titles = [
    'home' => 'MaskHosting - Offshore DMCA Ignored Hosting | Privacy-First Solutions',
    'about' => 'About Us - MaskHosting',
    'shared-hosting' => 'Offshore Shared Hosting - MaskHosting',
    'vps-hosting' => 'VPS & Cloud Hosting - MaskHosting',
    'domains' => 'Domain Registration - MaskHosting',
    'pricing' => 'Pricing Plans - MaskHosting',
    'contact' => 'Contact Us - MaskHosting',
    'features' => 'Features - MaskHosting',
    'faq' => 'FAQ - MaskHosting'
];

// Meta Descriptions
$meta_descriptions = [
    'home' => 'MaskHosting provides offshore DMCA ignored hosting with maximum privacy and security. Get shared hosting, VPS, cloud hosting, and domain registration services.',
    'about' => 'Learn about MaskHosting\'s mission to provide secure, private, and reliable offshore hosting solutions.',
    'shared-hosting' => 'Affordable offshore shared hosting with DMCA ignored policies, unlimited bandwidth, and 99.9% uptime guarantee.',
    'vps-hosting' => 'Powerful VPS and cloud hosting solutions with full root access, offshore locations, and complete privacy.',
    'domains' => 'Register your domain with complete privacy protection and WHOIS guard included.',
    'pricing' => 'View our competitive pricing for offshore hosting, VPS, and domain registration services.',
    'contact' => 'Get in touch with MaskHosting support team. We\'re here to help 24/7.',
    'features' => 'Explore MaskHosting\'s powerful features including offshore locations, DMCA ignored policies, and enterprise-grade security.',
    'faq' => 'Find answers to frequently asked questions about our offshore hosting services.'
];

// Current page detection
function getCurrentPage() {
    $page = basename($_SERVER['PHP_SELF'], '.php');
    return $page;
}

// Get page title
function getPageTitle() {
    global $page_titles;
    $page = getCurrentPage();
    return isset($page_titles[$page]) ? $page_titles[$page] : SITE_NAME;
}

// Get meta description
function getMetaDescription() {
    global $meta_descriptions;
    $page = getCurrentPage();
    return isset($meta_descriptions[$page]) ? $meta_descriptions[$page] : '';
}
?>
