<?php include 'header.php'; ?>

<!-- Page Header -->
<section class="page-header py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="page-header-title mb-4">Contact Us</h1>
        <p class="page-header-subtitle">We're here to help 24/7. Reach out to us anytime!</p>
    </div>
</section>

<!-- Contact Section -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12">
            <!-- Contact Form -->
            <div>
                <h2 class="text-3xl font-bold mb-6">Send Us a Message</h2>
                <p class="text-gray-400 mb-8">Fill out the form below and our team will get back to you within 24 hours.</p>
                
                <form id="contactForm" class="space-y-6">
                    <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                        <div class="form-group">
                            <label for="name" class="form-label">Full Name</label>
                            <input type="text" id="name" name="name" required class="form-input">
                        </div>
                        <div class="form-group">
                            <label for="email" class="form-label">Email Address</label>
                            <input type="email" id="email" name="email" required class="form-input">
                        </div>
                    </div>
                    
                    <div class="form-group">
                        <label for="subject" class="form-label">Subject</label>
                        <select id="subject" name="subject" required class="form-input">
                            <option value="">Select a subject...</option>
                            <option value="sales">Sales Inquiry</option>
                            <option value="support">Technical Support</option>
                            <option value="billing">Billing Question</option>
                            <option value="partnership">Partnership Opportunity</option>
                            <option value="other">Other</option>
                        </select>
                    </div>
                    
                    <div class="form-group">
                        <label for="message" class="form-label">Message</label>
                        <textarea id="message" name="message" rows="6" required class="form-input"></textarea>
                    </div>
                    
                    <button type="submit" class="btn-primary w-full">
                        <i class="fas fa-paper-plane mr-2"></i>Send Message
                    </button>
                </form>
                
                <div id="formMessage" class="mt-4 p-4 rounded-lg" style="display: none;"></div>
            </div>
            
            <!-- Contact Info -->
            <div>
                <h2 class="text-3xl font-bold mb-6">Get In Touch</h2>
                <p class="text-gray-400 mb-8">Prefer to reach out directly? Here are all the ways you can contact us.</p>
                
                <div class="space-y-6">
                    <!-- Sales -->
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-shopping-cart"></i>
                        </div>
                        <div>
                            <h3 class="contact-title">Sales Team</h3>
                            <p class="contact-text">Questions about our plans or need help choosing?</p>
                            <a href="mailto:<?php echo SALES_EMAIL; ?>" class="contact-link"><?php echo SALES_EMAIL; ?></a>
                        </div>
                    </div>
                    
                    <!-- Support -->
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-headset"></i>
                        </div>
                        <div>
                            <h3 class="contact-title">Technical Support</h3>
                            <p class="contact-text">Existing customer? Our support team is here to help.</p>
                            <a href="mailto:<?php echo CONTACT_EMAIL; ?>" class="contact-link"><?php echo CONTACT_EMAIL; ?></a>
                        </div>
                    </div>
                    
                    <!-- Phone -->
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-phone"></i>
                        </div>
                        <div>
                            <h3 class="contact-title">Phone Support</h3>
                            <p class="contact-text">Speak with a representative (Mon-Fri, 9AM-5PM EST)</p>
                            <a href="tel:<?php echo str_replace([' ', '(', ')', '-'], '', CONTACT_PHONE); ?>" class="contact-link"><?php echo CONTACT_PHONE; ?></a>
                        </div>
                    </div>
                    
                    <!-- Live Chat -->
                    <div class="contact-card">
                        <div class="contact-icon">
                            <i class="fas fa-comments"></i>
                        </div>
                        <div>
                            <h3 class="contact-title">Live Chat</h3>
                            <p class="contact-text">Get instant help via live chat on our website</p>
                            <button onclick="alert('Live chat would open here')" class="contact-link">Start Chat</button>
                        </div>
                    </div>
                </div>
                
                <!-- Social Media -->
                <div class="mt-12">
                    <h3 class="text-xl font-bold mb-4">Follow Us</h3>
                    <div class="flex space-x-4">
                        <a href="<?php echo TWITTER_URL; ?>" class="social-icon-large">
                            <i class="fab fa-twitter"></i>
                        </a>
                        <a href="<?php echo FACEBOOK_URL; ?>" class="social-icon-large">
                            <i class="fab fa-facebook"></i>
                        </a>
                        <a href="<?php echo TELEGRAM_URL; ?>" class="social-icon-large">
                            <i class="fab fa-telegram"></i>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- FAQ Section -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-4">Common Questions</h2>
        <p class="text-center text-gray-400 mb-12">Quick answers to questions you might have</p>
        
        <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
            <div class="quick-faq">
                <i class="fas fa-clock text-3xl text-primary mb-3"></i>
                <h3 class="text-lg font-bold mb-2">What are your support hours?</h3>
                <p class="text-gray-400 text-sm">We provide 24/7/365 support via email and ticket system. Phone support is available Mon-Fri, 9AM-5PM EST.</p>
            </div>
            
            <div class="quick-faq">
                <i class="fas fa-bolt text-3xl text-primary mb-3"></i>
                <h3 class="text-lg font-bold mb-2">How fast is your response time?</h3>
                <p class="text-gray-400 text-sm">Most tickets are answered within 1 hour. Critical issues are handled immediately.</p>
            </div>
            
            <div class="quick-faq">
                <i class="fas fa-globe text-3xl text-primary mb-3"></i>
                <h3 class="text-lg font-bold mb-2">Where are your servers located?</h3>
                <p class="text-gray-400 text-sm">We have servers in privacy-friendly offshore locations including Netherlands, Romania, and Iceland.</p>
            </div>
            
            <div class="quick-faq">
                <i class="fas fa-question-circle text-3xl text-primary mb-3"></i>
                <h3 class="text-lg font-bold mb-2">Need more help?</h3>
                <p class="text-gray-400 text-sm">Check our <a href="faq.php" class="text-primary hover:underline">comprehensive FAQ page</a> for detailed answers.</p>
            </div>
        </div>
    </div>
</section>

<style>
    .form-group {
        width: 100%;
    }
    
    .form-label {
        display: block;
        margin-bottom: 0.5rem;
        font-weight: 600;
        color: #d1d5db;
    }
    
    .form-input {
        width: 100%;
        padding: 1rem;
        background: rgba(15, 22, 41, 0.6);
        border: 2px solid rgba(0, 255, 136, 0.2);
        border-radius: 8px;
        color: white;
        font-size: 1rem;
        transition: all 0.3s ease;
    }
    
    .form-input:focus {
        outline: none;
        border-color: var(--primary);
        box-shadow: 0 0 20px rgba(0, 255, 136, 0.2);
    }
    
    select.form-input {
        cursor: pointer;
    }
    
    textarea.form-input {
        resize: vertical;
        min-height: 150px;
    }
    
    .contact-card {
        display: flex;
        gap: 1.5rem;
        padding: 1.5rem;
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        transition: all 0.3s ease;
    }
    
    .contact-card:hover {
        border-color: var(--primary);
        transform: translateX(5px);
        box-shadow: 0 10px 30px rgba(0, 255, 136, 0.2);
    }
    
    .contact-icon {
        width: 60px;
        height: 60px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.5rem;
        color: var(--primary);
        flex-shrink: 0;
    }
    
    .contact-title {
        font-size: 1.3rem;
        font-weight: 700;
        margin-bottom: 0.5rem;
    }
    
    .contact-text {
        color: #9ca3af;
        margin-bottom: 0.5rem;
    }
    
    .contact-link {
        color: var(--primary);
        font-weight: 600;
        transition: all 0.3s ease;
        cursor: pointer;
        display: inline-block;
    }
    
    .contact-link:hover {
        transform: translateX(5px);
    }
    
    .social-icon-large {
        width: 50px;
        height: 50px;
        border-radius: 50%;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid rgba(0, 255, 136, 0.3);
        display: flex;
        align-items: center;
        justify-content: center;
        color: var(--primary);
        font-size: 1.5rem;
        transition: all 0.3s ease;
    }
    
    .social-icon-large:hover {
        background: var(--primary);
        color: var(--dark);
        transform: translateY(-5px) scale(1.1);
        box-shadow: 0 10px 20px rgba(0, 255, 136, 0.3);
    }
    
    .quick-faq {
        padding: 2rem;
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        transition: all 0.3s ease;
    }
    
    .quick-faq:hover {
        border-color: var(--primary);
        transform: translateY(-5px);
        box-shadow: 0 10px 30px rgba(0, 255, 136, 0.2);
    }
    
    .quick-faq i {
        display: block;
    }
</style>

<script>
    document.getElementById('contactForm').addEventListener('submit', function(e) {
        e.preventDefault();
        
        const formMessage = document.getElementById('formMessage');
        
        // Simulate form submission
        formMessage.style.display = 'block';
        formMessage.style.background = 'rgba(0, 255, 136, 0.1)';
        formMessage.style.border = '1px solid var(--primary)';
        formMessage.style.color = 'var(--primary)';
        formMessage.innerHTML = '<i class="fas fa-check-circle mr-2"></i>Thank you! Your message has been sent. We\'ll get back to you within 24 hours.';
        
        // Reset form
        this.reset();
        
        // Scroll to message
        formMessage.scrollIntoView({ behavior: 'smooth', block: 'center' });
    });
</script>

<?php include 'footer.php'; ?>
