<?php include 'header.php'; ?>

<!-- Page Header -->
<section class="page-header py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h1 class="page-header-title mb-4">Transparent Pricing</h1>
        <p class="page-header-subtitle">Choose the perfect plan for your needs. No hidden fees, cancel anytime.</p>
    </div>
</section>

<!-- Pricing Toggle -->
<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="flex justify-center items-center gap-4 mb-12">
            <span class="text-lg" id="monthlyLabel" style="color: var(--primary); font-weight: 700;">Monthly</span>
            <label class="pricing-switch">
                <input type="checkbox" id="pricingToggle">
                <span class="slider"></span>
            </label>
            <span class="text-lg text-gray-400" id="annualLabel">Annual <span class="text-primary text-sm">(Save 20%)</span></span>
        </div>
    </div>
</section>

<!-- Shared Hosting Pricing -->
<section class="py-12">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-12">Offshore Shared Hosting</h2>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <!-- Starter Plan -->
            <div class="pricing-card">
                <div class="plan-header">
                    <h3 class="plan-name">Starter</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">4.99</span>
                        <span class="price-amount annual-price" style="display: none;">3.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>1 Website</li>
                    <li><i class="fas fa-check"></i>10 GB SSD Storage</li>
                    <li><i class="fas fa-check"></i>Unlimited Bandwidth</li>
                    <li><i class="fas fa-check"></i>Free SSL Certificate</li>
                    <li><i class="fas fa-check"></i>cPanel Control Panel</li>
                    <li><i class="fas fa-check"></i>Daily Backups</li>
                    <li><i class="fas fa-check"></i>24/7 Support</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=1" class="btn-secondary w-full text-center mt-6">Get Started</a>
            </div>
            
            <!-- Professional Plan -->
            <div class="pricing-card featured">
                <div class="popular-badge">Most Popular</div>
                <div class="plan-header">
                    <h3 class="plan-name">Professional</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">9.99</span>
                        <span class="price-amount annual-price" style="display: none;">7.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>5 Websites</li>
                    <li><i class="fas fa-check"></i>50 GB SSD Storage</li>
                    <li><i class="fas fa-check"></i>Unlimited Bandwidth</li>
                    <li><i class="fas fa-check"></i>Free SSL Certificate</li>
                    <li><i class="fas fa-check"></i>cPanel Control Panel</li>
                    <li><i class="fas fa-check"></i>Daily Backups</li>
                    <li><i class="fas fa-check"></i>Priority Support</li>
                    <li><i class="fas fa-check"></i>Free Domain (1 Year)</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=2" class="btn-primary w-full text-center mt-6">Get Started</a>
            </div>
            
            <!-- Business Plan -->
            <div class="pricing-card">
                <div class="plan-header">
                    <h3 class="plan-name">Business</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">19.99</span>
                        <span class="price-amount annual-price" style="display: none;">15.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>Unlimited Websites</li>
                    <li><i class="fas fa-check"></i>100 GB SSD Storage</li>
                    <li><i class="fas fa-check"></i>Unlimited Bandwidth</li>
                    <li><i class="fas fa-check"></i>Free SSL Certificate</li>
                    <li><i class="fas fa-check"></i>cPanel Control Panel</li>
                    <li><i class="fas fa-check"></i>Hourly Backups</li>
                    <li><i class="fas fa-check"></i>Premium Support</li>
                    <li><i class="fas fa-check"></i>Free Domain (1 Year)</li>
                    <li><i class="fas fa-check"></i>Free Website Migration</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=3" class="btn-secondary w-full text-center mt-6">Get Started</a>
            </div>
        </div>
    </div>
</section>

<!-- VPS Pricing -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-12">VPS & Cloud Hosting</h2>
        
        <div class="grid grid-cols-1 md:grid-cols-4 gap-6">
            <!-- VPS Basic -->
            <div class="pricing-card">
                <div class="plan-header">
                    <h3 class="plan-name">VPS Basic</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">19.99</span>
                        <span class="price-amount annual-price" style="display: none;">15.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>2 CPU Cores</li>
                    <li><i class="fas fa-check"></i>4 GB RAM</li>
                    <li><i class="fas fa-check"></i>50 GB SSD</li>
                    <li><i class="fas fa-check"></i>2 TB Bandwidth</li>
                    <li><i class="fas fa-check"></i>Full Root Access</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=10" class="btn-secondary w-full text-center mt-6">Order Now</a>
            </div>
            
            <!-- VPS Standard -->
            <div class="pricing-card">
                <div class="plan-header">
                    <h3 class="plan-name">VPS Standard</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">39.99</span>
                        <span class="price-amount annual-price" style="display: none;">31.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>4 CPU Cores</li>
                    <li><i class="fas fa-check"></i>8 GB RAM</li>
                    <li><i class="fas fa-check"></i>100 GB SSD</li>
                    <li><i class="fas fa-check"></i>4 TB Bandwidth</li>
                    <li><i class="fas fa-check"></i>Full Root Access</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=11" class="btn-secondary w-full text-center mt-6">Order Now</a>
            </div>
            
            <!-- VPS Advanced -->
            <div class="pricing-card">
                <div class="plan-header">
                    <h3 class="plan-name">VPS Advanced</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">79.99</span>
                        <span class="price-amount annual-price" style="display: none;">63.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>8 CPU Cores</li>
                    <li><i class="fas fa-check"></i>16 GB RAM</li>
                    <li><i class="fas fa-check"></i>200 GB SSD</li>
                    <li><i class="fas fa-check"></i>8 TB Bandwidth</li>
                    <li><i class="fas fa-check"></i>Full Root Access</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=12" class="btn-secondary w-full text-center mt-6">Order Now</a>
            </div>
            
            <!-- VPS Enterprise -->
            <div class="pricing-card">
                <div class="plan-header">
                    <h3 class="plan-name">VPS Enterprise</h3>
                    <div class="plan-price">
                        <span class="price-symbol">$</span>
                        <span class="price-amount monthly-price">149.99</span>
                        <span class="price-amount annual-price" style="display: none;">119.99</span>
                        <span class="price-period">/mo</span>
                    </div>
                </div>
                <ul class="plan-features">
                    <li><i class="fas fa-check"></i>16 CPU Cores</li>
                    <li><i class="fas fa-check"></i>32 GB RAM</li>
                    <li><i class="fas fa-check"></i>500 GB SSD</li>
                    <li><i class="fas fa-check"></i>16 TB Bandwidth</li>
                    <li><i class="fas fa-check"></i>Full Root Access</li>
                </ul>
                <a href="<?php echo CLIENT_AREA_URL; ?>/cart.php?a=add&pid=13" class="btn-secondary w-full text-center mt-6">Order Now</a>
            </div>
        </div>
    </div>
</section>

<!-- Domain Pricing -->
<section class="py-20">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-4">Domain Registration</h2>
        <p class="text-center text-gray-400 mb-12">Register your domain with complete privacy protection</p>
        
        <div class="domain-pricing-table">
            <div class="domain-row header-row">
                <div class="domain-ext">Extension</div>
                <div class="domain-price">Register</div>
                <div class="domain-price">Transfer</div>
                <div class="domain-price">Renew</div>
            </div>
            <div class="domain-row">
                <div class="domain-ext">.com</div>
                <div class="domain-price">$9.99/yr</div>
                <div class="domain-price">$9.99/yr</div>
                <div class="domain-price">$11.99/yr</div>
            </div>
            <div class="domain-row">
                <div class="domain-ext">.net</div>
                <div class="domain-price">$11.99/yr</div>
                <div class="domain-price">$11.99/yr</div>
                <div class="domain-price">$13.99/yr</div>
            </div>
            <div class="domain-row">
                <div class="domain-ext">.org</div>
                <div class="domain-price">$10.99/yr</div>
                <div class="domain-price">$10.99/yr</div>
                <div class="domain-price">$12.99/yr</div>
            </div>
            <div class="domain-row">
                <div class="domain-ext">.io</div>
                <div class="domain-price">$39.99/yr</div>
                <div class="domain-price">$39.99/yr</div>
                <div class="domain-price">$39.99/yr</div>
            </div>
            <div class="domain-row">
                <div class="domain-ext">.app</div>
                <div class="domain-price">$14.99/yr</div>
                <div class="domain-price">$14.99/yr</div>
                <div class="domain-price">$16.99/yr</div>
            </div>
            <div class="domain-row">
                <div class="domain-ext">.dev</div>
                <div class="domain-price">$12.99/yr</div>
                <div class="domain-price">$12.99/yr</div>
                <div class="domain-price">$14.99/yr</div>
            </div>
        </div>
        
        <div class="text-center mt-8">
            <a href="domains.php" class="btn-primary">Search Domains</a>
        </div>
    </div>
</section>

<!-- FAQ -->
<section class="py-20 bg-gradient-to-b from-transparent to-blue-900/10">
    <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
        <h2 class="text-3xl font-bold text-center mb-12">Frequently Asked Questions</h2>
        
        <div class="space-y-4">
            <div class="faq-item">
                <button class="faq-question">
                    <span>What payment methods do you accept?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>We accept all major credit cards (Visa, Mastercard, American Express), PayPal, and cryptocurrency (Bitcoin, Ethereum) for maximum privacy.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Do you offer refunds?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Yes! We offer a 30-day money-back guarantee on all shared hosting plans. VPS and dedicated servers have a 7-day money-back guarantee.</p>
                </div>
            </div>
            
            <div class="faq-item">
                <button class="faq-question">
                    <span>Can I upgrade my plan later?</span>
                    <i class="fas fa-chevron-down"></i>
                </button>
                <div class="faq-answer">
                    <p>Absolutely! You can upgrade your hosting plan at any time from your client area. The difference will be prorated.</p>
                </div>
            </div>
        </div>
    </div>
</section>

<style>
    .pricing-switch {
        position: relative;
        display: inline-block;
        width: 60px;
        height: 30px;
    }
    
    .pricing-switch input {
        opacity: 0;
        width: 0;
        height: 0;
    }
    
    .slider {
        position: absolute;
        cursor: pointer;
        top: 0;
        left: 0;
        right: 0;
        bottom: 0;
        background-color: rgba(0, 255, 136, 0.2);
        transition: 0.4s;
        border-radius: 30px;
        border: 2px solid var(--primary);
    }
    
    .slider:before {
        position: absolute;
        content: "";
        height: 20px;
        width: 20px;
        left: 3px;
        bottom: 3px;
        background-color: var(--primary);
        transition: 0.4s;
        border-radius: 50%;
    }
    
    input:checked + .slider:before {
        transform: translateX(30px);
    }
    
    .pricing-card {
        background: rgba(15, 22, 41, 0.8);
        border: 2px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 2.5rem;
        position: relative;
        transition: all 0.3s ease;
    }
    
    .pricing-card.featured {
        border-color: var(--primary);
        box-shadow: 0 0 40px rgba(0, 255, 136, 0.3);
        transform: scale(1.05);
    }
    
    .pricing-card:hover {
        transform: translateY(-10px);
        border-color: var(--primary);
        box-shadow: 0 20px 50px rgba(0, 255, 136, 0.3);
    }
    
    .popular-badge {
        position: absolute;
        top: -15px;
        right: 20px;
        background: var(--primary);
        color: var(--dark);
        padding: 8px 20px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.85rem;
        text-transform: uppercase;
    }
    
    .plan-header {
        text-align: center;
        margin-bottom: 2rem;
        padding-bottom: 2rem;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
    }
    
    .plan-name {
        font-size: 1.8rem;
        font-weight: 700;
        margin-bottom: 1rem;
        color: var(--primary);
    }
    
    .plan-price {
        display: flex;
        align-items: baseline;
        justify-content: center;
    }
    
    .price-symbol {
        font-size: 1.5rem;
        color: #9ca3af;
    }
    
    .price-amount {
        font-family: 'Orbitron', monospace;
        font-size: 3.5rem;
        font-weight: 900;
        color: white;
        margin: 0 0.25rem;
    }
    
    .price-period {
        font-size: 1.2rem;
        color: #6b7280;
    }
    
    .plan-features {
        list-style: none;
        margin-bottom: 2rem;
    }
    
    .plan-features li {
        padding: 0.75rem 0;
        color: #d1d5db;
        display: flex;
        align-items: center;
        gap: 0.75rem;
    }
    
    .plan-features i {
        color: var(--primary);
        font-size: 1rem;
    }
    
    .domain-pricing-table {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        overflow: hidden;
    }
    
    .domain-row {
        display: grid;
        grid-template-columns: 1fr 1fr 1fr 1fr;
        gap: 1rem;
        padding: 1.5rem;
        border-bottom: 1px solid rgba(255, 255, 255, 0.1);
        transition: all 0.3s ease;
    }
    
    .domain-row:last-child {
        border-bottom: none;
    }
    
    .domain-row:not(.header-row):hover {
        background: rgba(0, 255, 136, 0.05);
    }
    
    .header-row {
        background: rgba(0, 255, 136, 0.1);
        font-weight: 700;
        color: var(--primary);
    }
    
    .domain-ext {
        font-weight: 600;
    }
    
    .domain-price {
        text-align: center;
        color: #d1d5db;
    }
    
    .faq-item {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        overflow: hidden;
        transition: all 0.3s ease;
    }
    
    .faq-item:hover {
        border-color: var(--primary);
    }
    
    .faq-question {
        width: 100%;
        padding: 1.5rem;
        background: transparent;
        border: none;
        color: white;
        font-size: 1.1rem;
        font-weight: 600;
        text-align: left;
        display: flex;
        justify-content: space-between;
        align-items: center;
        cursor: pointer;
        transition: all 0.3s ease;
    }
    
    .faq-question:hover {
        color: var(--primary);
    }
    
    .faq-question i {
        transition: transform 0.3s ease;
    }
    
    .faq-item.active .faq-question i {
        transform: rotate(180deg);
    }
    
    .faq-answer {
        max-height: 0;
        overflow: hidden;
        transition: max-height 0.3s ease;
    }
    
    .faq-item.active .faq-answer {
        max-height: 500px;
    }
    
    .faq-answer p {
        padding: 0 1.5rem 1.5rem;
        color: #9ca3af;
        line-height: 1.7;
    }
    
    @media (max-width: 768px) {
        .domain-row {
            grid-template-columns: 1fr;
            text-align: center;
        }
        
        .header-row {
            display: none;
        }
        
        .domain-price::before {
            content: attr(data-label);
            font-weight: 600;
            margin-right: 0.5rem;
        }
    }
</style>

<script>
    // Pricing toggle
    const toggle = document.getElementById('pricingToggle');
    const monthlyLabel = document.getElementById('monthlyLabel');
    const annualLabel = document.getElementById('annualLabel');
    const monthlyPrices = document.querySelectorAll('.monthly-price');
    const annualPrices = document.querySelectorAll('.annual-price');
    
    toggle.addEventListener('change', function() {
        if (this.checked) {
            monthlyPrices.forEach(p => p.style.display = 'none');
            annualPrices.forEach(p => p.style.display = 'inline');
            monthlyLabel.style.color = '#9ca3af';
            monthlyLabel.style.fontWeight = '400';
            annualLabel.style.color = 'var(--primary)';
            annualLabel.style.fontWeight = '700';
        } else {
            monthlyPrices.forEach(p => p.style.display = 'inline');
            annualPrices.forEach(p => p.style.display = 'none');
            monthlyLabel.style.color = 'var(--primary)';
            monthlyLabel.style.fontWeight = '700';
            annualLabel.style.color = '#9ca3af';
            annualLabel.style.fontWeight = '400';
        }
    });
    
    // FAQ accordion
    document.querySelectorAll('.faq-question').forEach(question => {
        question.addEventListener('click', () => {
            const item = question.parentElement;
            const isActive = item.classList.contains('active');
            
            document.querySelectorAll('.faq-item').forEach(i => i.classList.remove('active'));
            
            if (!isActive) {
                item.classList.add('active');
            }
        });
    });
</script>

<?php include 'footer.php'; ?>
