<?php include 'header.php'; ?>

<!-- Hero Section -->
<section class="hero-section relative py-20 md:py-32">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <div class="inline-block mb-4">
                <span class="badge">
                    <i class="fas fa-shield-halved mr-2"></i>Offshore DMCA Ignored
                </span>
            </div>
            <h1 class="hero-title mb-6">Offshore Shared Hosting</h1>
            <p class="hero-description max-w-3xl mx-auto mb-10">
                Experience true freedom with our offshore shared hosting. Host your websites with complete privacy, DMCA ignored policies, and bulletproof reliability. Starting at just $4.99/month.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="pricing.php" class="btn-primary text-lg px-10 py-4">
                    <i class="fas fa-rocket mr-2"></i>View Plans
                </a>
                <a href="<?php echo CLIENT_AREA_URL; ?>" class="btn-secondary text-lg px-10 py-4">
                    <i class="fas fa-sign-in-alt mr-2"></i>Client Area
                </a>
            </div>
        </div>
    </div>
</section>

<!-- Features Grid -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Premium Features Included</h2>
            <p class="section-description">Everything you need to succeed online, all in one package</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-tachometer-alt"></i>
                </div>
                <h3 class="feature-title">SSD Storage</h3>
                <p class="feature-text">Lightning-fast NVMe SSD storage for superior website performance and loading speeds.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-infinity"></i>
                </div>
                <h3 class="feature-title">Unlimited Bandwidth</h3>
                <p class="feature-text">No traffic limits or throttling. Handle unlimited visitors without extra charges.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-lock"></i>
                </div>
                <h3 class="feature-title">Free SSL Certificates</h3>
                <p class="feature-text">Secure your websites with free SSL certificates. Boost SEO and visitor trust.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-desktop"></i>
                </div>
                <h3 class="feature-title">cPanel Control Panel</h3>
                <p class="feature-text">Industry-standard cPanel for easy website management and one-click installations.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-database"></i>
                </div>
                <h3 class="feature-title">Daily Backups</h3>
                <p class="feature-text">Automatic daily backups keep your data safe. Restore anytime with one click.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <h3 class="feature-title">Unlimited Email</h3>
                <p class="feature-text">Create unlimited professional email accounts for your domain with webmail access.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-wordpress"></i>
                </div>
                <h3 class="feature-title">1-Click WordPress</h3>
                <p class="feature-text">Install WordPress and 400+ other apps instantly with Softaculous.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-user-secret"></i>
                </div>
                <h3 class="feature-title">Privacy Protected</h3>
                <p class="feature-text">Your data stays private. We don't log, monitor, or share your information.</p>
            </div>
            
            <div class="feature-card">
                <div class="feature-icon">
                    <i class="fas fa-headset"></i>
                </div>
                <h3 class="feature-title">24/7 Expert Support</h3>
                <p class="feature-text">Round-the-clock support from real hosting experts via ticket and live chat.</p>
            </div>
        </div>
    </div>
</section>

<!-- Why Offshore Section -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-12 items-center">
            <div>
                <h2 class="section-title text-left">Why Choose Offshore Hosting?</h2>
                <p class="text-gray-400 text-lg mb-8 leading-relaxed">
                    Offshore hosting provides legal protection and freedom that traditional hosting cannot match. Here's why thousands choose MaskHosting:
                </p>
                
                <div class="space-y-6">
                    <div class="offshore-benefit">
                        <div class="benefit-number">01</div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">DMCA Ignored</h3>
                            <p class="text-gray-400">Host content without fear of frivolous DMCA takedown requests affecting your business.</p>
                        </div>
                    </div>
                    
                    <div class="offshore-benefit">
                        <div class="benefit-number">02</div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Maximum Privacy</h3>
                            <p class="text-gray-400">Located in privacy-friendly jurisdictions with strong data protection laws.</p>
                        </div>
                    </div>
                    
                    <div class="offshore-benefit">
                        <div class="benefit-number">03</div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Freedom of Speech</h3>
                            <p class="text-gray-400">Express yourself freely without censorship or political interference.</p>
                        </div>
                    </div>
                    
                    <div class="offshore-benefit">
                        <div class="benefit-number">04</div>
                        <div>
                            <h3 class="text-xl font-bold mb-2">Legal Protection</h3>
                            <p class="text-gray-400">Our offshore location provides additional legal layers protecting your content.</p>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="offshore-visual">
                <div class="globe-container">
                    <i class="fas fa-globe text-9xl text-primary opacity-30"></i>
                    <div class="location-pins">
                        <div class="pin pin-1"></div>
                        <div class="pin pin-2"></div>
                        <div class="pin pin-3"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- Technical Specifications -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Technical Specifications</h2>
            <p class="section-description">Enterprise-grade infrastructure for maximum performance</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <div class="spec-card">
                <i class="fas fa-server text-4xl text-primary mb-4"></i>
                <h3 class="text-lg font-bold mb-2">Hardware</h3>
                <p class="text-gray-400 text-sm">Latest Intel Xeon processors with NVMe SSD storage</p>
            </div>
            
            <div class="spec-card">
                <i class="fas fa-network-wired text-4xl text-primary mb-4"></i>
                <h3 class="text-lg font-bold mb-2">Network</h3>
                <p class="text-gray-400 text-sm">1Gbps+ premium bandwidth with DDoS protection</p>
            </div>
            
            <div class="spec-card">
                <i class="fas fa-shield-alt text-4xl text-primary mb-4"></i>
                <h3 class="text-lg font-bold mb-2">Security</h3>
                <p class="text-gray-400 text-sm">Advanced firewall, malware scanning, and SSL</p>
            </div>
            
            <div class="spec-card">
                <i class="fas fa-chart-line text-4xl text-primary mb-4"></i>
                <h3 class="text-lg font-bold mb-2">Uptime</h3>
                <p class="text-gray-400 text-sm">99.9% uptime SLA with full redundancy</p>
            </div>
        </div>
    </div>
</section>

<!-- Supported Technologies -->
<section class="py-20 bg-gradient-to-b from-transparent to-blue-900/10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Supported Technologies</h2>
            <p class="section-description">Run any application with our comprehensive tech stack</p>
        </div>
        
        <div class="grid grid-cols-2 md:grid-cols-4 lg:grid-cols-6 gap-8">
            <div class="tech-item">
                <i class="fab fa-php text-5xl text-primary mb-3"></i>
                <p class="font-semibold">PHP 8.x</p>
            </div>
            <div class="tech-item">
                <i class="fab fa-python text-5xl text-primary mb-3"></i>
                <p class="font-semibold">Python</p>
            </div>
            <div class="tech-item">
                <i class="fab fa-node-js text-5xl text-primary mb-3"></i>
                <p class="font-semibold">Node.js</p>
            </div>
            <div class="tech-item">
                <i class="fas fa-database text-5xl text-primary mb-3"></i>
                <p class="font-semibold">MySQL</p>
            </div>
            <div class="tech-item">
                <i class="fab fa-wordpress text-5xl text-primary mb-3"></i>
                <p class="font-semibold">WordPress</p>
            </div>
            <div class="tech-item">
                <i class="fab fa-laravel text-5xl text-primary mb-3"></i>
                <p class="font-semibold">Laravel</p>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">Ready to Get Started?</h2>
        <p class="text-xl text-gray-400 mb-10">Join thousands of customers who trust MaskHosting for offshore shared hosting.</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="pricing.php" class="btn-primary text-lg px-10 py-4">
                <i class="fas fa-rocket mr-2"></i>Choose Your Plan
            </a>
            <a href="contact.php" class="btn-secondary text-lg px-10 py-4">
                <i class="fas fa-comments mr-2"></i>Talk to Sales
            </a>
        </div>
    </div>
</section>

<style>
    .offshore-benefit {
        display: flex;
        gap: 1.5rem;
        align-items: start;
    }
    
    .benefit-number {
        font-family: 'Orbitron', monospace;
        font-size: 2rem;
        font-weight: 900;
        color: rgba(0, 255, 136, 0.3);
        min-width: 60px;
    }
    
    .offshore-visual {
        display: flex;
        justify-content: center;
        align-items: center;
        position: relative;
        height: 400px;
    }
    
    .globe-container {
        position: relative;
        display: flex;
        justify-content: center;
        align-items: center;
    }
    
    .location-pins {
        position: absolute;
        width: 100%;
        height: 100%;
    }
    
    .pin {
        position: absolute;
        width: 20px;
        height: 20px;
        background: var(--primary);
        border-radius: 50%;
        box-shadow: 0 0 20px rgba(0, 255, 136, 0.6);
        animation: pinPulse 2s ease-in-out infinite;
    }
    
    .pin-1 {
        top: 30%;
        left: 20%;
    }
    
    .pin-2 {
        top: 50%;
        right: 25%;
        animation-delay: 0.5s;
    }
    
    .pin-3 {
        bottom: 30%;
        left: 35%;
        animation-delay: 1s;
    }
    
    @keyframes pinPulse {
        0%, 100% {
            transform: scale(1);
            opacity: 1;
        }
        50% {
            transform: scale(1.3);
            opacity: 0.7;
        }
    }
    
    .spec-card {
        text-align: center;
        padding: 2rem;
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 12px;
        transition: all 0.3s ease;
    }
    
    .spec-card:hover {
        transform: translateY(-5px);
        border-color: var(--primary);
        box-shadow: 0 15px 35px rgba(0, 255, 136, 0.2);
    }
    
    .spec-card i {
        display: block;
        margin: 0 auto;
    }
    
    .tech-item {
        text-align: center;
        padding: 1.5rem;
        transition: all 0.3s ease;
    }
    
    .tech-item:hover {
        transform: translateY(-10px);
    }
    
    .tech-item i {
        display: block;
        margin: 0 auto;
        transition: all 0.3s ease;
    }
    
    .tech-item:hover i {
        transform: scale(1.2);
    }
</style>

<?php include 'footer.php'; ?>
