<?php include 'header.php'; ?>

<!-- Hero Section -->
<section class="hero-section relative py-20 md:py-32">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center">
            <div class="inline-block mb-4">
                <span class="badge">
                    <i class="fas fa-server mr-2"></i>Powerful & Private
                </span>
            </div>
            <h1 class="hero-title mb-6">Offshore VPS & Cloud Hosting</h1>
            <p class="hero-description max-w-3xl mx-auto mb-10">
                Experience enterprise-grade performance with complete privacy. Our offshore VPS and cloud hosting solutions offer full root access, dedicated resources, and DMCA ignored policies. From $19.99/month.
            </p>
            <div class="flex flex-col sm:flex-row gap-4 justify-center">
                <a href="pricing.php" class="btn-primary text-lg px-10 py-4">
                    <i class="fas fa-rocket mr-2"></i>View Plans
                </a>
                <a href="contact.php" class="btn-secondary text-lg px-10 py-4">
                    <i class="fas fa-phone mr-2"></i>Contact Sales
                </a>
            </div>
        </div>
    </div>
</section>

<!-- VPS vs Cloud -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">VPS or Cloud? Choose Your Power</h2>
            <p class="section-description">Both offer dedicated resources and privacy. Pick what fits your needs.</p>
        </div>
        
        <div class="grid grid-cols-1 lg:grid-cols-2 gap-8">
            <!-- VPS Hosting -->
            <div class="comparison-card">
                <div class="comparison-icon">
                    <i class="fas fa-server"></i>
                </div>
                <h3 class="text-2xl font-bold mb-4">VPS Hosting</h3>
                <p class="text-gray-400 mb-6">Perfect for established websites and applications requiring dedicated resources.</p>
                
                <ul class="comparison-features mb-6">
                    <li><i class="fas fa-check text-primary mr-3"></i>Dedicated CPU & RAM</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Full Root Access</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Choice of Linux or Windows</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Instant Provisioning</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Fixed Monthly Pricing</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>99.9% Uptime SLA</li>
                </ul>
                
                <div class="text-center">
                    <p class="text-3xl font-bold text-primary mb-4">From $19.99/mo</p>
                    <a href="pricing.php#vps" class="btn-primary w-full text-center">Choose VPS</a>
                </div>
            </div>
            
            <!-- Cloud Hosting -->
            <div class="comparison-card featured">
                <div class="comparison-badge">Best for Growth</div>
                <div class="comparison-icon">
                    <i class="fas fa-cloud"></i>
                </div>
                <h3 class="text-2xl font-bold mb-4">Cloud Hosting</h3>
                <p class="text-gray-400 mb-6">Scalable infrastructure that grows with your business automatically.</p>
                
                <ul class="comparison-features mb-6">
                    <li><i class="fas fa-check text-primary mr-3"></i>Auto-Scaling Resources</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Load Balancing</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Multiple Data Centers</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>CDN Integration</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>Pay-As-You-Grow</li>
                    <li><i class="fas fa-check text-primary mr-3"></i>99.99% Uptime SLA</li>
                </ul>
                
                <div class="text-center">
                    <p class="text-3xl font-bold text-primary mb-4">From $29.99/mo</p>
                    <a href="pricing.php#cloud" class="btn-primary w-full text-center">Choose Cloud</a>
                </div>
            </div>
        </div>
    </div>
</section>

<!-- VPS Features -->
<section class="py-20 bg-gradient-to-b from-blue-900/10 to-transparent">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Premium VPS Features</h2>
            <p class="section-description">Everything you need for high-performance hosting</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
            <div class="vps-feature">
                <i class="fas fa-rocket text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">NVMe SSD Storage</h3>
                <p class="text-gray-400">Ultra-fast NVMe drives deliver 10x faster performance than traditional SSDs.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fas fa-microchip text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">Latest Intel Xeon</h3>
                <p class="text-gray-400">Powered by latest-generation Intel Xeon processors for maximum compute power.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fas fa-shield-virus text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">DDoS Protection</h3>
                <p class="text-gray-400">Advanced DDoS mitigation protects your server from attacks 24/7.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fas fa-hdd text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">Automated Backups</h3>
                <p class="text-gray-400">Daily automated backups with instant restore capability keep data safe.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fas fa-network-wired text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">Premium Network</h3>
                <p class="text-gray-400">Multi-gigabit premium bandwidth with global peering for low latency.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fas fa-terminal text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">Full Root Access</h3>
                <p class="text-gray-400">Complete control with full root/administrator access to customize everything.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fab fa-linux text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">OS Flexibility</h3>
                <p class="text-gray-400">Choose from multiple Linux distributions or Windows Server editions.</p>
            </div>
            
            <div class="vps-feature">
                <i class="fas fa-bolt text-5xl text-primary mb-4"></i>
                <h3 class="text-xl font-bold mb-3">Instant Setup</h3>
                <p class="text-gray-400">Your VPS is provisioned and ready to use within 5 minutes of ordering.</p>
            </div>
        </div>
    </div>
</section>

<!-- Use Cases -->
<section class="py-20">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Perfect For Any Project</h2>
            <p class="section-description">Our VPS hosting powers all types of applications</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
            <div class="use-case-card">
                <div class="use-case-icon">
                    <i class="fas fa-shopping-cart"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">E-Commerce Sites</h3>
                <p class="text-gray-400">Host WooCommerce, Magento, or custom online stores with dedicated resources for peak traffic.</p>
            </div>
            
            <div class="use-case-card">
                <div class="use-case-icon">
                    <i class="fas fa-gamepad"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Game Servers</h3>
                <p class="text-gray-400">Run Minecraft, CS:GO, Rust, and other game servers with low latency and high performance.</p>
            </div>
            
            <div class="use-case-card">
                <div class="use-case-icon">
                    <i class="fas fa-code"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Development</h3>
                <p class="text-gray-400">Create isolated dev environments with full control for testing and staging.</p>
            </div>
            
            <div class="use-case-card">
                <div class="use-case-icon">
                    <i class="fas fa-video"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Streaming</h3>
                <p class="text-gray-400">Stream video content with high bandwidth and offshore privacy protection.</p>
            </div>
            
            <div class="use-case-card">
                <div class="use-case-icon">
                    <i class="fas fa-database"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Database Hosting</h3>
                <p class="text-gray-400">Host MySQL, PostgreSQL, MongoDB with dedicated resources and daily backups.</p>
            </div>
            
            <div class="use-case-card">
                <div class="use-case-icon">
                    <i class="fas fa-envelope"></i>
                </div>
                <h3 class="text-xl font-bold mb-3">Email Servers</h3>
                <p class="text-gray-400">Run your own private email server with complete control and privacy.</p>
            </div>
        </div>
    </div>
</section>

<!-- Management Options -->
<section class="py-20 bg-gradient-to-b from-transparent to-blue-900/10">
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
        <div class="text-center mb-16">
            <h2 class="section-title">Choose Your Management Level</h2>
            <p class="section-description">From self-managed to fully managed, we've got you covered</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-3 gap-8">
            <div class="management-card">
                <h3 class="text-2xl font-bold mb-4">Self-Managed</h3>
                <div class="text-4xl font-bold text-primary mb-4">Included</div>
                <p class="text-gray-400 mb-6">You have complete control. We provide the infrastructure, you manage the server.</p>
                <ul class="mb-6 space-y-3">
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>Full root access</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>OS installation</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>Basic support</span></li>
                </ul>
            </div>
            
            <div class="management-card featured">
                <div class="management-badge">Popular</div>
                <h3 class="text-2xl font-bold mb-4">Semi-Managed</h3>
                <div class="text-4xl font-bold text-primary mb-4">+$29/mo</div>
                <p class="text-gray-400 mb-6">We handle server setup and basic maintenance while you focus on your application.</p>
                <ul class="mb-6 space-y-3">
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>All Self-Managed features</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>cPanel/WHM installation</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>Security updates</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>Priority support</span></li>
                </ul>
            </div>
            
            <div class="management-card">
                <h3 class="text-2xl font-bold mb-4">Fully Managed</h3>
                <div class="text-4xl font-bold text-primary mb-4">+$99/mo</div>
                <p class="text-gray-400 mb-6">Sit back and relax. We handle everything from setup to monitoring and optimization.</p>
                <ul class="mb-6 space-y-3">
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>All Semi-Managed features</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>24/7 monitoring</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>Performance optimization</span></li>
                    <li class="flex items-start"><i class="fas fa-check text-primary mr-3 mt-1"></i><span>Software installations</span></li>
                </ul>
            </div>
        </div>
    </div>
</section>

<!-- CTA Section -->
<section class="py-20">
    <div class="max-w-5xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
        <h2 class="text-4xl md:text-5xl font-bold mb-6">Ready for Enterprise Performance?</h2>
        <p class="text-xl text-gray-400 mb-10">Get your offshore VPS or cloud server deployed in minutes.</p>
        <div class="flex flex-col sm:flex-row gap-4 justify-center">
            <a href="pricing.php" class="btn-primary text-lg px-10 py-4">
                <i class="fas fa-rocket mr-2"></i>View Pricing
            </a>
            <a href="contact.php" class="btn-secondary text-lg px-10 py-4">
                <i class="fas fa-comments mr-2"></i>Talk to Expert
            </a>
        </div>
    </div>
</section>

<style>
    .comparison-card {
        background: rgba(15, 22, 41, 0.8);
        border: 2px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 3rem;
        position: relative;
        transition: all 0.3s ease;
    }
    
    .comparison-card.featured {
        border-color: var(--primary);
        box-shadow: 0 0 40px rgba(0, 255, 136, 0.3);
    }
    
    .comparison-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 50px rgba(0, 255, 136, 0.3);
    }
    
    .comparison-badge {
        position: absolute;
        top: -15px;
        right: 20px;
        background: var(--primary);
        color: var(--dark);
        padding: 8px 20px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.85rem;
        text-transform: uppercase;
    }
    
    .comparison-icon {
        width: 80px;
        height: 80px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 20px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2.5rem;
        color: var(--primary);
        margin-bottom: 2rem;
    }
    
    .comparison-features {
        list-style: none;
    }
    
    .comparison-features li {
        padding: 0.75rem 0;
        display: flex;
        align-items: center;
        color: #d1d5db;
    }
    
    .vps-feature {
        text-align: center;
        padding: 2rem;
        transition: all 0.3s ease;
    }
    
    .vps-feature:hover {
        transform: translateY(-10px);
    }
    
    .vps-feature i {
        display: block;
        margin: 0 auto;
        transition: all 0.3s ease;
    }
    
    .vps-feature:hover i {
        transform: scale(1.2);
    }
    
    .use-case-card {
        background: rgba(15, 22, 41, 0.6);
        border: 1px solid rgba(0, 255, 136, 0.2);
        border-radius: 16px;
        padding: 2rem;
        text-align: center;
        transition: all 0.3s ease;
    }
    
    .use-case-card:hover {
        transform: translateY(-5px);
        border-color: var(--primary);
        box-shadow: 0 15px 35px rgba(0, 255, 136, 0.2);
    }
    
    .use-case-icon {
        width: 70px;
        height: 70px;
        background: rgba(0, 255, 136, 0.1);
        border: 2px solid var(--primary);
        border-radius: 16px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 2rem;
        color: var(--primary);
        margin: 0 auto 1.5rem;
        transition: all 0.3s ease;
    }
    
    .use-case-card:hover .use-case-icon {
        transform: scale(1.1) rotate(5deg);
    }
    
    .management-card {
        background: rgba(15, 22, 41, 0.8);
        border: 2px solid rgba(0, 255, 136, 0.2);
        border-radius: 20px;
        padding: 2.5rem;
        text-align: center;
        position: relative;
        transition: all 0.3s ease;
    }
    
    .management-card.featured {
        border-color: var(--primary);
        box-shadow: 0 0 40px rgba(0, 255, 136, 0.3);
    }
    
    .management-card:hover {
        transform: translateY(-10px);
        box-shadow: 0 20px 50px rgba(0, 255, 136, 0.3);
    }
    
    .management-badge {
        position: absolute;
        top: -15px;
        right: 20px;
        background: var(--primary);
        color: var(--dark);
        padding: 8px 20px;
        border-radius: 50px;
        font-weight: 700;
        font-size: 0.85rem;
        text-transform: uppercase;
    }
</style>

<?php include 'footer.php'; ?>
